
-- 

USE BD_Air_France;

EXEC sp_configure 'clr enabled',1;
GO
RECONFIGURE;
GO


IF OBJECT_ID ('dbo.T_vehicules_veh','U') IS NOT NULL
    DROP TABLE dbo.T_vehicules_veh;
GO

CREATE TABLE T_vehicules_veh
(veh_immat VARCHAR(9) PRIMARY KEY, 
 veh_km    INT, 
 veh_mail  VARCHAR(30));

INSERT INTO T_vehicules_veh VALUES ('RT-125-YV', 3850,  'brouard@gmail.com');
INSERT INTO T_vehicules_veh VALUES ('ET342TH',   34723, 'elsuket-123@gmail.com');
INSERT INTO T_vehicules_veh VALUES ('AA-392-RJ', 30,    'paul.soutou@cictfr');

SELECT  veh_immat
FROM    T_vehicules_veh
WHERE   dbo.RegexMatch(veh_immat,'^[^IOU]{2}-[1-9][0-9]{0,2}-[^IOU]{2}$') = 1;

SELECT  veh_mail
FROM    T_vehicules_veh
WHERE   dbo.RegexMatch(veh_mail,'^[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,4}$') = 1;

SELECT  CAST(dbo.RegExReplace(veh_immat,'[a-zA-Z]','') AS VARCHAR(15)) AS "sans lettres",
        veh_immat
FROM    T_vehicules_veh;

SELECT  CAST(dbo.RegExReplace(veh_mail,'[0-9@.-]','') AS VARCHAR(20)) AS "sans chiffres et symboles",  
        veh_mail
FROM    T_vehicules_veh;

SELECT CAST(dbo.RegexSelectOne('RT-125-YFAA-128-FZ',
                               '[A-Z]{2}-[1-9][0-9]{0,2}-[A-Z]{2}', 1) AS VARCHAR(15));

SELECT CAST(dbo.RegexSelectAll('RT-125-YFlkkkAA-128-FZ',
                               '[A-Z]{2}-[1-9][0-9]{0,2}-[A-Z]{2}', '/') AS VARCHAR(30));

IF OBJECT_ID ('dbo.T_vehicules_veh','U') IS NOT NULL
    DROP TABLE dbo.T_vehicules_veh;
GO

CREATE TABLE T_vehicules_veh
(veh_immat VARCHAR(9) PRIMARY KEY, 
 veh_km    INT, 
 veh_mail  VARCHAR(30),
 CONSTRAINT ck_expr_immat CHECK 
	(dbo.RegexMatch(veh_immat,'^[^IOU]{2}-[1-9][0-9]{0,2}-[^IOU]{2}$')=1),
  CONSTRAINT ck2_expr_immat CHECK 
	(UPPER(veh_immat) NOT LIKE 'SS-%' AND veh_immat NOT LIKE 'WW-%' AND veh_immat NOT LIKE '%-SS'),
  CONSTRAINT c_expr_mail CHECK 
	(dbo.RegexMatch(veh_mail,'^[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,4}$')=1));

--bons

INSERT INTO T_vehicules_veh VALUES ('RT-125-YV', 3850,  'brouard@gmail.com');
INSERT INTO T_vehicules_veh VALUES ('AA-392-RJ', 30,    'paul.soutou@cict.fr');

-- mauvais

INSERT INTO T_vehicules_veh VALUES ('ET342TH',   34723, 'elsuket-123@gmail.com');
INSERT INTO T_vehicules_veh VALUES ('AB-390-RJ', 30,    'paul.soutou@cictfr');


IF OBJECT_ID ('dbo.T_vehicules_veh','U') IS NOT NULL
    DROP TABLE dbo.T_vehicules_veh;
GO

